<?php
defined('BASEPATH') or exit('No direct script access allowed');
define('DOMPDF_ENABLE_AUTOLOAD', false);
require_once FCPATH . "./vendor/dompdf/dompdf/dompdf_config.inc.php";

use Mpdf\Mpdf;
use TCPDF;

class Pdfgenerator
{
    public function generate($html, $filename = '', $stream = true, $paper = 'A4', $orientation = "portrait")
    {
        $dompdf = new DOMPDF();
        $dompdf->load_html($html);
        $dompdf->set_paper($paper, $orientation);
        $dompdf->render();
        $dompdf->isRemoteEnabled = true;
        if ($stream) {
            $dompdf->stream($filename . ".pdf", array("Attachment" => 1));
        } else {
            return $dompdf->output();
        }
    }
    public function mpdf($html, $filename = '', $dest = 'I', $config = [])
    {
        $mpdf = new Mpdf($config);
        $mpdf->WriteHTML($html);
        $mpdf->Output($filename, $dest);
    }
    public function tcpdf($html, $filename, $division_id = null, $save = false, $type = 'manager', $incident = null)
    {
        $settings = $this->get_tcpdf_settings($type);
        $tcpdf = new MYPDF($settings['orientation'], 'in', $settings['page_size']);
        $letter = $tcpdf->CI->letter_model->get_letter_with_deleted($incident->letter_id);

        if($incident && in_array($incident->status, ['rejected', 'contested-r'])){
            $tcpdf->image_path = APPPATH . array_to_path(['modules', 'incident', 'assets', 'original_letter_heads', 'rejected.png']);
        } else {
            $division_id = 'image_' . $division_id;
            if(!empty($settings[$division_id])){
                $tcpdf->image_path = APPPATH . array_to_path(['modules', 'incident', 'assets', 'letter_heads', $settings[$division_id]]);
            }
        }

        $tcpdf->SetFont($settings['font_style'], '', $settings['font_size']);

        if(empty(trim($letter->footer_note))){
            $tcpdf->setPrintFooter(false);
        } else {
            $tcpdf->__footer_note = trim($letter->footer_note);
        }

        $tcpdf->SetMargins($settings['margin_left'], $settings['margin_top'], $settings['margin_right'], true);
        $tcpdf->SetAutoPageBreak(true, $settings['margin_bottom']);

        $tcpdf->AddPage();

        $tcpdf->writeHTML($html);
        $tcpdf->Output($filename, $save ? 'F' : 'I');
    }
    private function get_tcpdf_settings($type = 'manager')
    {
        $recs = getByWhere('tcpdf_settings', '*', [], [], 0, 0, ['name' => $type . '%']);
        $data = [];
        foreach ($recs as $rec) {
            $rec->name = str_replace($type . '_', '', $rec->name);
            $data[$rec->name] = $rec->value;
        }
        return $data;
    }
    public function html_to_pdf($html, $filename, $save = false, $image = null, $password = null, $footer_note = null, $page_size = null, $orientation = null)
    {
        $settings = $this->get_tcpdf_settings('manager');
        $tcpdf = new MYPDF($orientation ? $orientation : $settings['orientation'], 'in', $page_size ? $page_size : $settings['page_size']);

        if($password) {
            $tcpdf->SetProtection([], $password, $password . date('My'));
        }

        $tcpdf->image_path = $image;

        $tcpdf->SetFont($settings['font_style'], '', $settings['font_size']);

        if(empty(trim($footer_note))){
            $tcpdf->setPrintFooter(false);
        } else {
            $tcpdf->__footer_note = trim($footer_note);
        }

        $tcpdf->SetMargins($settings['margin_left'], $settings['margin_top'], $settings['margin_right'], true);
        $tcpdf->SetAutoPageBreak(true, $settings['margin_bottom']);

        $tcpdf->AddPage();

        $tcpdf->writeHTML($html);
        $tcpdf->Output($filename, $save ? 'F' : 'I');
    }
}
class MYPDF extends TCPDF
{
    public $image_path;
    public $CI;
    public $cu_page_size;
    public $__footer_note = '';
    public function __construct($orientation = 'P', $unit = 'mm', $format = 'A4', $unicode = true, $encoding = 'UTF-8', $diskcache = false, $pdfa = false)
    {
        parent::__construct($orientation, $unit, $format, $unicode, $encoding, $diskcache, $pdfa);
        $this->cu_page_size = $format;
        $this->CI = &get_instance();
        $this->CI->load->model('incident/letter_model');
    }
    public function Header()
    {
        if (!$this->image_path || !file_exists($this->image_path)) {
            return;
        }
        $bMargin = $this->getBreakMargin();
        $auto_page_break = $this->AutoPageBreak;

        $curr_dim = $this->CI->letter_model->get_page_size($this->cu_page_size);
        $dims = [];
        switch ($this->CurOrientation) {
            case 'L':{
                    $dims = [$curr_dim[1], $curr_dim[0]];
                    break;
                }
            case 'P':{
                    $dims = [$curr_dim[0], $curr_dim[1]];
                    break;
                }
        }

        $this->SetAutoPageBreak(false, 0);
        $this->Image($this->image_path, 0, 0, $dims[0], $dims[1], '', '', '', false, 300, '', false, false, 0);
        $this->SetAutoPageBreak($auto_page_break, $bMargin);
        $this->setPageMark();
    }
    public function Footer() {
        $cur_y = $this->y - $this->getBreakMargin(1);
		$this->SetY($cur_y);

		$this->SetTextColorArray($this->footer_text_color);

        $this->SetX($this->original_lMargin);
        $this->SetFont('helvetica', 'I', 8);
        $this->Cell(0, 0, $this->__footer_note, null, 0, 'C');
    }
}
