<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

require_once 'PHPExcel.php';

class Excel extends PHPExcel
{

    public function __construct()
    {
        parent::__construct();
    }
    public function read($path)
    {
        $file_type = PHPExcel_IOFactory::identify($path);
        $objReader = PHPExcel_IOFactory::createReader($file_type);
        $objPHPExcel = $objReader->load($path);
        $sheet_data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
        return $sheet_data;
    }
    public function download_excel($name)
    {
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $name . '.xls"'); // file name of excel
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($this, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }
    public function download_csv($name)
    {
        header('Content-type: text/csv');
        header('Content-Disposition: attachment;filename="' . $name . '.csv"'); // file name of excel
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = new PHPExcel_Writer_CSV($this);
        $objWriter->setDelimiter(',');
        $objWriter->setEnclosure('');
        $objWriter->setLineEnding("\r\n");
        $objWriter->setSheetIndex(0);
        $objWriter->save('php://output');
        exit;
    }
}
