<?php
require_once APPPATH . 'libraries/Mysql_type.php';

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

/**
 * Class library made to auto detect column type from query and format excel cell accordingly
 *
 * @author Ahmed Raza ahmed.raza@proglobaltechnologies.com
 */
class Better_excel
{
    public function create($header, $rows, $meta = [], $sheet_info = [], $comments = [], $freeze = 'A2', $styles = [], $zoom_level = 100, $grid_lines = false)
    {
        $spreadsheet = new Spreadsheet();
        $properties = $spreadsheet->getProperties();

        if (@$sheet_info['author']) {
            $properties->setCreator(@$sheet_info['author']);
        }
        if (@$sheet_info['modifier']) {
            $properties->setLastModifiedBy(@$sheet_info['modifier']);
        }
        if (@$sheet_info['title']) {
            $properties->setTitle(@$sheet_info['title']);
        }
        if (@$sheet_info['subject']) {
            $properties->setSubject(@$sheet_info['subject']);
        }
        if (@$sheet_info['description']) {
            $properties->setDescription(@$sheet_info['description']);
        }

        $sheet = $spreadsheet->getActiveSheet();

        if (@$sheet_info['sheet_title']) {
            $sheet->setTitle(@$sheet_info['sheet_title']);
        }
        $sheet->setShowGridlines($grid_lines);
        $sheet->getSheetView()->setZoomScale($zoom_level);

        //Set Header
        $last_column = null;
        foreach ($header as $column => $value) {
            $column += 1;
            $cell = $sheet->getCellByColumnAndRow($column, 1);
            $cell->setValueExplicit(
                is_string($value) ? $value : $value[0],
                \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
            );
            $sheet->getColumnDimension($cell->getColumn())->setWidth(is_string($value) ? 20 : $value[1]);
            $last_column = $cell->getColumn();
        }
        $sheet->freezePane($freeze);
        if ($last_column) {
            $sheet->getStyle("A1:{$last_column}1")->applyFromArray([
                'fill' => [
                    'color' => [
                        'rgb' => 'C5BE97',
                    ],
                    'fillType' => Fill::FILL_SOLID,
                ],
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => [
                            'rgb' => '000000',
                        ],
                    ],
                ],
                'font' => [
                    'bold' => 1,
                ],
                'alignment' => [
                    'horizontal' => Alignment::HORIZONTAL_CENTER,
                    'vertical' => Alignment::VERTICAL_CENTER,
                    'wrapText' => 1,
                ],
            ]);
        }
        //Set Data
        $row = 1;
        foreach ($rows as $columns) {
            $row++;
            foreach ($columns as $column => $value) {

                $cell = $sheet->getCellByColumnAndRow($column + 1, $row);

                if (@$comments[$row - 2] && @$comments[$row - 2][$column]) {
                    foreach ($comments[$row - 2][$column] as $comment) {
                        $t_coord = $cell->getCoordinate();

                        $sheet->getComment($t_coord)
                            ->setAuthor('HRM Payroll System');
                        $sheet->getComment($t_coord)
                            ->setWidth('500px')->setHeight('300px');
                        $commentRichText = $sheet->getComment($t_coord)
                            ->getText()
                            ->createTextRun($comment['user_name']);
                        $commentRichText->getFont()->setBold(true);
                        $sheet->getComment($t_coord)
                            ->getText()->createTextRun("\r\n");
                        $sheet->getComment($t_coord)
                            ->getText()->createTextRun('PKR ' . number_format($comment['value']) . ': ' . $comment['reason']);
                        $sheet->getComment($t_coord)
                            ->getText()->createTextRun("\r\n");
                    }
                }

                if (empty($meta)) {
                    $cell->setValue($value);
                } else {
                    $mysql_types = new Mysql_type();
                    $mysql_type = $meta[$column];
                    switch ($mysql_types->check_type($mysql_type)) {
                        case $mysql_types::IS_INT:{
                                $cell->setValueExplicit(
                                    floatval($value),
                                    \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_NUMERIC
                                );
                                $cell->getStyle()->getNumberFormat()->setFormatCode('#,##0');
                                break;
                            }
                        case $mysql_types::IS_DATE:{
                                $timestamp = \PhpOffice\PhpSpreadsheet\Shared\Date::PHPToExcel($value);
                                if (!$timestamp) {
                                    $cell->setValueExplicit(
                                        $value,
                                        \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                                    );
                                } else {
                                    $cell->setValue($timestamp);
                                    $cell->getStyle()->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_SHORT);
                                }
                                break;
                            }
                        case $mysql_types::IS_DATETIME:{
                                $timestamp = \PhpOffice\PhpSpreadsheet\Shared\Date::PHPToExcel($value);
                                if (!$timestamp) {
                                    $cell->setValueExplicit(
                                        $value,
                                        \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                                    );
                                } else {
                                    $cell->setValue($timestamp);
                                    $cell->getStyle()->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_DATETIME);
                                }
                                break;
                            }
                        case $mysql_types::IS_URL:{
                                $cell->setValue($value);
                                $cell->getStyle()->applyFromArray([
                                    'font' => [
                                        'color' => ['rgb' => '1155cc'],
                                        'underline' => Font::UNDERLINE_SINGLE,
                                    ],
                                ]);
                                $cell->getHyperlink()->setUrl($value);
                                break;
                            }
                        default:{
                                $cell->setValueExplicit(
                                    $value,
                                    \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                                );
                                break;
                            }
                    }
                }
            }
        }
        if ($last_column) {
            $sheet->getStyle("A1:{$last_column}{$row}")->applyFromArray(array_merge([
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => [
                            'rgb' => '000000',
                        ],
                    ],
                ],
            ], $styles));
        }

        return $spreadsheet;
    }
    public function download($header, $rows, $meta = [], $sheet_info = [], $comments = [], $file_name = 'adhoc-report', $freeze = 'A2', $styles = [], $zoom_level = 100, $grid_lines = false)
    {
        $writer = new Xlsx($this->create($header, $rows, $meta, $sheet_info, $comments, $freeze, $styles, $zoom_level, $grid_lines));
        header('Content-Description: File Transfer');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . $file_name . '.xlsx"');
        header('Content-Transfer-Encoding: binary');

        $writer->save('php://output');
    }
    public function file($path, $header, $rows, $meta = [], $sheet_info = [], $comments = [], $freeze = 'A2', $styles = [], $zoom_level = 100, $grid_lines = false)
    {
        $writer = IOFactory::createWriter($this->create($header, $rows, $meta, $sheet_info, $comments, $freeze, $styles, $zoom_level, $grid_lines), 'Xlsx');
        $writer->save($path);
    }
}
