<?php
/* Employee Module */
$lang['employee_created'] = 'Created Employee {{employee:name}}';
$lang['employee_deleted'] = 'Deleted Employee {{employee:name}}';
$lang['employee_update'] = 'Changed \'%s\' from \'%s\' to \'%s\'';

$lang['employee_add_increment'] = 'Added %s salary increment: \'%s\' (Dated: %s)';
$lang['employee_update_increment'] = 'Changed %s salary increment: from \'%s\' (Dated: %s) to \'%s\' (Dated: %s)';
$lang['employee_remove_increment'] = 'Removed %s salary increment: \'%s\' (Dated: %s)';

$lang['employee_update_request'] = 'Approved request to change \'%s\' from \'%s\' to \'%s\'';
$lang['employee_update_request_rejected'] = 'Rejected a request to change \'%s\' from \'%s\' to \'%s\'';
$lang['employee_document_added'] = 'Added a document "%s"';
$lang['employee_document_added_missing'] = 'Added a missing document "%s"';
$lang['employee_document_removed'] = 'Removed a document "%s"';
$lang['employee_probation_extension'] = 'Extended probation by %s<br>Reason: "%s"';
$lang['employee_contract_extension'] = 'Extended contract by %s<br>Reason: "%s"';
$lang['employee_document_approved'] = 'Approved document "%s"';
$lang['employee_document_rejected'] = 'Rejected document "%s"<br>Reason: %s';

$lang['employee_document_type_added'] = 'Added a document type "%s " (#%s)';
$lang['employee_document_type_updated'] = 'Updated document type "%s" (#%s)';
$lang['employee_document_type_deleted'] = 'Removed a document type "%s" (#%s)';

/* Gender */
$lang['gender_inserted'] = 'Added new gender "%s"';
$lang['marital_status_inserted'] = 'Added new marital status "%s"';
$lang['position_inserted'] = 'Added new position "%s"';
$lang['position_updated'] = 'Updated position "%s (#%s)"';
$lang['position_deleted'] = 'Deleted position "%s (#%s)"';

/* Attendance Module */
$lang['attendance_inserted'] = 'Added punch %s time \'%s\' for {{employee:name}}';
$lang['attendance_manual_checkout'] = 'Added checkout \'%s\' for {{employee:name}}';
$lang['full_attendance_inserted'] = 'Added attendance entry \'%s - %s\' for {{employee:name}}';

$lang['attendance_group_update_in'] = 'Updated check-in of \'%s\' day to \'%s\' for {{employee:name}}';
$lang['attendance_group_update'] = 'Updated attendance of \'%s\' day to \'IN: %s - OUT: %s\' for {{employee:name}}';
$lang['attendance_group_deleted'] = 'Deleted attendance of \'%s\' day for {{employee:name}}';

$lang['timeadjustment_processed'] = '[%s] %s time adjustment request \'#%s\' of \'{{employee:name}}\' for \'%s\' day';

/* Award Module */
$lang['award_type_inserted'] = 'Added new award type \'%s\'';
$lang['award_type_updated'] = 'Updated award type \'%s\'';
$lang['award_type_deleted'] = 'Deleted award type \'%s\'';
$lang['award_assigned'] = 'Assigned an award \'%s\' to {{employee:name}}';
$lang['award_updated'] = 'Updated award \'%s (#%s)\' of {{employee:name}}';
$lang['award_status_updated'] = '%s award \'%s (#%s)\' of {{employee:name}}';
$lang['award_deleted'] = 'Deleted award \'%s (#%s)\' of {{employee:name}}';

/* Settings Module */
$lang['language_inserted'] = 'Added new phrase \'%s\' for languages';
$lang['language_updated'] = 'Updated phrases for \'%s\' language';
$lang['menu_inserted'] = 'Added new menu \'%s\'';
$lang['menu_updated'] = 'Updated menu \'%s (#%s)\'';
$lang['menu_deleted'] = 'Deleted menu \'%s (#%s)\'';
/* Roles */
$lang['role_inserted'] = 'Added new role \'%s\'';
$lang['role_updated'] = 'Updated role \'%s (#%s)\'';
$lang['role_assigned'] = 'Assigned role \'%s\' to {{employee:name}}';
$lang['role_unassigned'] = 'Removed role \'%s\' from {{employee:name}}';
$lang['role_deleted'] = 'Deleted role \'%s (#%s)\'';
$lang['user_access_deleted'] = 'Deleted HRM access and roles for \'%s %s\'';

$lang['benefit_inserted'] = 'Added new benefit \'%s\'';
$lang['benefit_updated'] = 'Updated benefit \'%s (#%s)\'';
$lang['benefit_deleted'] = 'Deleted benefit \'%s (#%s)\'';
$lang['message_inserted'] = 'Sent a message \'%s\' to {{employee:name}}';
$lang['message_deleted'] = 'Deleted a message #%s \'%s\' sent to {{employee:name}}';
$lang['module_inserted'] = 'Installed new module \'%s\'';
$lang['module_deleted'] = 'Uninstalled module \'%s\'';
$lang['module_status_changed'] = '%s module #%s \'%s\'';
$lang['setting_inserted'] = 'Added settings for site \'%s\'';
$lang['setting_updated'] = 'Updated settings for site \'%s\'';
$lang['ftp_inserted'] = 'Added ftp settings with hostname \'%s\'';
$lang['ftp_updated'] = 'Updated ftp settings with hostname \'%s\'';
$lang['temp_category_inserted'] = 'Added new document template category \'%s\'';
$lang['temp_category_updated'] = 'Updated document template category \'%s (#%s)\'';
$lang['temp_category_deleted'] = 'Deleted document template category \'%s (#%s)\'';
$lang['document_template_inserted'] = 'Added new document template \'%s\'';
$lang['document_template_updated'] = 'Updated document template \'%s (#%s)\'';
$lang['document_template_deleted'] = 'Deleted document template \'%s (#%s)\'';
$lang['user_inserted'] = 'Added new user for employee \'{{employee:name}}\'';
$lang['user_updated'] = 'Updated user for employee \'{{employee:name}}\'';
$lang['user_deleted'] = 'Deleted user for employee \'{{employee:name}}\'';
$lang['user_updated_self'] = 'Updated their own user profile (about/password, etc)';
$lang['email_settings_inserted'] = 'Added email setting for division \'{{division:name}}\'';
$lang['email_settings_updated'] = 'Updated email setting for division \'{{division:name}}\'';
$lang['email_settings_deleted'] = 'Deleted email setting for division \'{{division:name}}\'';
$lang['email_settings_testing'] = 'Initiated a test email for division \'{{division:name}}\' to \'%s\'';

/* Department Module */
$lang['shift_inserted'] = 'Added new shift \'%s\'';
$lang['shift_updated'] = 'Updated shift \'{{shift:name}} (#{{shift:id}})\'';
$lang['shift_deleted'] = 'Deleted shift \'{{shift:name}} (#{{shift:id}})\'';
$lang['department_inserted'] = 'Added new department \'{{department:name}}\'';
$lang['department_updated'] = 'Updated department \'{{department:name}}\'';
$lang['department_deleted'] = 'Deleted department \'{{department:name}}\'';
$lang['division_inserted'] = 'Added new division \'{{division:name}}\'';
$lang['division_updated'] = 'Updated division \'{{division:name}}\'';
$lang['division_deleted'] = 'Deleted division \'{{division:name}}\'';

/* Incident Module */
$lang['incident_approved'] = 'Approved %s \'%s\' for {{employee:name}}';
$lang['incident_approved_outside'] = 'Approved %s \'%s\' for %s';
$lang['incident_rejected'] = 'Rejected %s \'%s\' for {{employee:name}}';
$lang['incident_rejected_outside'] = 'Rejected %s \'%s\' for %s';
$lang['incident_contestation_status'] = '%s contestation request for letter \'%s\' against {{employee:name}}';
$lang['incident_contestation_status_outside'] = '%s contestation request for letter \'%s\' against %s';
$lang['incident_contested'] = 'Contested rejection of letter \'%s\' against {{employee:name}}';
$lang['incident_contested_outside'] = 'Contested rejection of letter \'%s\' against %s';

$lang['letter_generated'] = 'Created a letter request \'%s\' #%s for {{employee:name}}';
$lang['incident_generated'] = 'Created an incident \'%s\' #%s for {{employee:name}}';
$lang['letter_generated_outside'] = 'Created a letter request \'%s\' #%s for %s';

$lang['incident_type_inserted'] = 'Added incident type \'%s\'';
$lang['incident_type_updated'] = 'Renamed incident type \'%s\' to \'%s\'';
$lang['incident_type_deleted'] = 'Deleted incident type \'%s (#%s)\'';

$lang['letter_inserted'] = 'Added a letter \'%s\' (SL# %s)';
$lang['letter_updated'] = 'Updated letter \'%s\' (SL# %s)';
$lang['letter_deleted'] = 'Deleted letter \'%s\' (SL# %s)';
$lang['pdf_settings_updated'] = 'Updated %s PDF settings';
$lang['pdf_settings_bg_removed'] = 'Removed background image from {{division:name}}\'s %s letter';

$lang['policy_inserted'] = 'Added a policy \'%s\' (SL# %s)';
$lang['policy_updated'] = 'Updated policy \'%s\' (SL# %s)';
$lang['policy_deleted'] = 'Deleted policy \'%s\' (SL# %s)';

$lang['letter_email_sent'] = 'Sent letter \'%s (#%s)\' to \'%s\' via email';
$lang['letter_policy_sent'] = 'Sent policy \'%s (#%s)\' to \'%s\' via email';

/* Leave Module */
$lang['weeklyleave_inserted'] = 'Added weekly holiday \'%s\' for \'{{shift:name}}\' shift';
$lang['weeklyleave_updated'] = 'Updated weekly holiday to \'%s\' for \'{{shift:name}}\' shift';
$lang['weeklyleave_deleted'] = 'Deleted weekly holiday \'%s\' for \'{{shift:name}}\' shift';

$lang['payroll_holiday_inserted'] = 'Added payroll holiday \'%s\' for \'{{shift:name}}\' shift';
$lang['payroll_holiday_updated'] = 'Updated payroll holiday \'%s\' (SL# %s)';
$lang['payroll_holiday_deleted'] = 'Deleted payroll holiday \'%s\' (SL# %s)';

$lang['leave_type_inserted'] = 'Added a leave type \'%s\'';
$lang['leave_type_updated'] = 'Updated leave type \'%s (#%s)\'';
$lang['leave_type_deleted'] = 'Deleted leave type \'%s (#%s)\'';

$lang['leave_denied'] = 'Denied leave application (#%s) of \'{{employee:name}}\' as %s';
$lang['leave_approved'] = 'Approved leave application (#%s) of \'{{employee:name}}\' as %s';
$lang['leave_deleted'] = 'Deleted leave application (#%s) of \'{{employee:name}}\'';

/* Noticeboard module */
$lang['notice_inserted'] = 'Added a notice \'%s\'';
$lang['notice_inserted_published'] = 'Added and published a notice \'%s\' to noticeboard';
$lang['notice_updated'] = 'Updated notice \'%s (#%s)\'';
$lang['notice_updated_published'] = 'Updated and published a notice \'%s (#%s)\' to noticeboard';
$lang['notice_deleted'] = 'Deleted a notice \'%s (#%s)\'';
$lang['notice_deleted_noticeboard'] = 'Deleted a notice \'%s (#%s)\' from noticeboard';

$lang['notification_deleted'] = 'Deleted a notification #%s<br>Title: %s';

/* Recruitment Module */
$lang['background_check_inserted'] = 'Added a background check for candidate \'{{candidate:name}}\'';

$lang['candidate_shortlisted'] = 'Shortlisted a candidate: \'{{candidate:name}}\' for \'{{job:name}}\'';
$lang['candidate_unshortlisted'] = 'Removed candidate from shortlist: \'{{candidate:name}}\' for \'{{job:name}}\'';
$lang['candidate_rejected'] = 'Rejected a candidate: \'{{candidate:name}}\' for \'{{job:name}}\'';
$lang['candidate_unrejected'] = 'Removed candidate from rejected list: \'{{candidate:name}}\' for \'{{job:name}}\'';
$lang['candidate_onboarded'] = 'On-boarded a candidate: \'{{candidate:name}}\' for \'{{job:name}}\'';
$lang['candidate_onboarding_rejected'] = 'Rejected On-boarding of candidate: \'{{candidate:name}}\' for \'{{job:name}}\'';
$lang['candidate_hired'] = 'Marked a candidate as hired: \'{{candidate:name}}\' for \'{{job:name}}\'';
$lang['candidate_updated'] = 'Updated candidate application of \'{{candidate:name}}\'';
$lang['candidate_deleted'] = 'Deleted candidate application of \'{{candidate:name}}\'';
$lang['candidate_moved_resource_pool'] = 'Moved candidate \'{{candidate:name}}\' to resource pool';
$lang['candidate_moved_job'] = 'Transferred candidate \'{{candidate:name}}\' from \'(#%s) %s\' to \'{{job:name}}\' job';
$lang['candidate_oriented'] = 'Generated credentials of candidate: \'{{candidate:name}}\'';
$lang['credentials_generated'] = 'Generated credentials with username: "%s"';

$lang['talent_deleted'] = 'Removed a candidate "%s %s" from talent network #%s';

$lang['interview_conducted'] = 'Marked interview done of \'{{candidate:name}}\' for {{job:name}}';
$lang['interview_scheduled'] = 'Scheduled interview (%s) of \'{{candidate:name}}\' for {{job:name}}. Interviewer \'{{employee:name}}\'';
$lang['interview_canceled'] = 'Canceled interview (%s) of \'{{candidate:name}}\' for {{job:name}}';

$lang['requisition_inserted'] = 'Added a requisition request \'{{job:name}}\'';
$lang['requisition_updated'] = 'Updated a requisition request \'{{job:name}}\'';
$lang['requisition_position_inserted'] = 'Added a new position \'%s\' via requisition';

$lang['job_deleted'] = 'Deleted a job listing for \'{{job:name}}\'';
$lang['job_referrer_state'] = '%s referrals for job listing \'{{job:name}}\'';

$lang['requisition_author_status'] = 'Re-submitted requisition for \'{{job:name}}\'';
$lang['requisition_rm_status'] = '%s requisition for \'{{job:name}}\'';
$lang['requisition_hr_status'] = 'Published ad for \'{{job:name}}\'';

$lang['requisition_option_inserted'] = 'Added a requisition option item \'%s\' in group \'%s\'';
$lang['requisition_option_updated'] = 'Updated a requisition option item \'%s\' in group \'%s\'';
$lang['requisition_option_deleted'] = 'Deleted a requisition option item \'%s\' in group \'%s\'';
$lang['requisition_option_sorted'] = 'Sorted requisition options of group \'%s\'';


/* Log Module */
$lang['email_requeued'] = 'Resent email #%s to \'%s\'';

/* Payroll Module */
$lang['taxslab_added'] = 'Added a tax slab with rate \'%s\'';
$lang['taxslab_updated'] = 'Updated a tax slab with rate \'%s\'';
$lang['taxslab_deleted'] = 'Delete a tax slab with rate \'%s\'';

/* Budget Sub Module */
$lang['budget_added'] = 'Generated a budget (#{{payroll:id}}) for {{division:name}} division, period {{payroll:start}} - {{payroll:end}}';
$lang['budget_regenerated'] = 'Regenerated budget (#{{payroll:id}}) for {{division:name}} - {{payroll:start}}, {{payroll:end}}';
$lang['budget_deleted'] = 'Deleted a budget (#%s) for {{division:name}} - %s, %s';

$lang['adjustment_added'] = 'Added PKR %s in %s for {{employee:name}} (Payroll: {{payroll:month}} {{payroll:year}})<br>Reason: %s';
$lang['adjustment_updated'] = 'Updated PKR %s in %s for {{employee:name}} (Payroll: {{payroll:month}} {{payroll:year}})<br>Reason: %s';
$lang['adjustment_deleted'] = 'Deleted PKR %s in %s for {{employee:name}} (Payroll: {{payroll:month}} {{payroll:year}})';
/* Payroll */
$lang['payroll_added'] = 'Generated a payroll (#{{payroll:id}}) for {{division:name}} - {{payroll:month}} {{payroll:year}}';
$lang['payroll_amend'] = 'Requested amendments on payroll (#{{payroll:id}}) for {{division:name}} - {{payroll:month}}, {{payroll:year}}<br>Reason: %s';
$lang['payroll_regenerated'] = 'Regenerated payroll (#{{payroll:id}}) for {{division:name}} - {{payroll:month}}, {{payroll:year}}';
$lang['payroll_approved'] = 'Approved payroll (#{{payroll:id}}) for {{division:name}} - {{payroll:month}}, {{payroll:year}} as %s';
$lang['payslips_generated'] = 'Sent slips for payroll {{division:name}} - {{payroll:month}}, {{payroll:year}}. (#{{payroll:id}})';

$lang['incident_letter_penalty_removed'] = 'Removed incident %s (%s) and its penalties for {{employee:name}}';

$lang['dropdown_value_added'] = 'Added a new option "%s" in %s dropdown';
$lang['dropdown_value_updated'] = 'Updated the option from "%s" to "%s" in %s dropdown';
$lang['dropdown_value_deleted'] = 'Deleted the option "%s" from %s dropdown';

$lang['leave_auto_increment'] = 'Auto incremented %s quota by 1 for %s month%s tenure';

$lang['rating_item_added'] = 'Added a new item "%s" to Evaluation Rating Scale #%s';
$lang['rating_item_updated'] = 'Updated item "%s" from Evaluation Rating Scale #%s';
$lang['rating_item_deleted'] = 'Deleted item "%s" from Evaluation Rating Scale #%s';

$lang['employee_roles_added'] = 'Added a new employee role "%s" for evaluation #%s';
$lang['employee_roles_updated'] = 'Updated employee role "%s" for evaluation #%s';
$lang['employee_roles_deleted'] = 'Deleted employee role "%s" for evaluation #%s';

$lang['evaluation_report_generated'] = 'Generated evaluation reports of \'{{employee:name}}\' for the year %s';

$lang['evaluation_behavior_added'] = 'Added a new behavior "%s" for evaluation #%s';
$lang['evaluation_behavior_updated'] = 'Updated behavior "%s" for evaluation #%s';
$lang['evaluation_behavior_deleted'] = 'Deleted behavior "%s" from evaluation #%s';

$lang['evaluation_objective_added'] = 'Added a new objective "%s" for evaluation #%s';
$lang['evaluation_objective_updated'] = 'Updated objective "%s" for evaluation #%s';
$lang['evaluation_objective_deleted'] = 'Deleted objective "%s" from evaluation #%s';

$lang['evaluation_year_data_re_fetched'] = 'Performed refetch of data for %s year evaluation reports.';
$lang['evaluation_val_db_updated'] = 'Update ValDB data for %s\'s %s %s evaluation report';

$lang['password_reset'] = 'Reset their own password';

$lang['drive_google_auth'] = 'Authenticated Google Drive storage using %s';

$lang['quiz_email_requeued'] = 'Resent quiz email #%s to \'%s\'';
$lang['quiz_settings_updated'] = 'Updated quiz module settings';
$lang['quiz_google_auth'] = 'Authenticated Google account "%s" for %s';
$lang['quiz_remove_google_auth'] = 'Un-authenticated Google account "%s" for %s';
$lang['quiz_created'] = 'Created a quiz "%s" using "%s" Google form #%s';
$lang['quiz_updated'] = 'Updated the "%s" quiz details #%s';
$lang['quiz_results_sent'] = 'Sent results of the "%s" quiz #%s';
$lang['quiz_results_sent_employee'] = 'Sent results of the "%s" quiz (#%s) to \'{{employee:name}}\'';
$lang['quiz_deleted'] = 'Deleted the "%s" quiz #%s';
$lang['quiz_deleted_employee'] = 'Deleted the \'{{employee:name}}\' from quiz \'%s\' #%s';
$lang['quiz_restored_employee'] = 'Restored the \'{{employee:name}}\' from quiz \'%s\' #%s';