<?php
class AuthHook
{
    private $CI = null;
    public function __construct()
    {
        $this->CI = &get_instance();
    }
    public function load()
    {
        $this->CI->load->driver('cache', array('adapter' => $this->cache_type(), 'backup' => 'file'));
        $this->CI->db->query('SET SESSION sql_mode = ""');
    }
    public function check_role()
    {
        if (!$this->CI->session->userdata('isLogIn')) {
            return;
        }
        if ($this->CI->session->userdata('isAdmin')) {
            return;
        }
        if ($this->CI->session->userdata('loaded') && $this->CI->session->userdata('roles')) {
            if ($this->role_updated()) {
                $this->CI->load->model('dashboard/auth_model');
                $this->CI->auth_model->reload_user_permissions();
            }
        }
    }
    private function role_updated()
    {
        $role_string = implode('', $this->CI->session->userdata('roles'));
        if (!$role_string) {
            $role_string = 'empty';
        }
        if (!$data = $this->CI->cache->get("role.updated.{$role_string}")) {
            $q = $this->CI->db
                ->select('role_id')
                ->where_in('role_id', $this->CI->session->userdata('roles'))
                ->where('updated_at >', $this->CI->session->userdata('loaded'))
            ->get('sec_role_tbl');
            if(!$q) {
                return false;
            }
            $recs = $q->result();
            $this->CI->cache->save("role.updated.{$role_string}", $recs, defined('STAGING_SERVER') ? 10 : 30);
            return $recs;
        }
        return $data;
    }
    private function cache_type()
    {
        if (extension_loaded('wincache') && ini_get('wincache.ucenabled')) {
            return 'wincache';
        } elseif (extension_loaded('apc') && ini_get('apc.enabled')) {
            return 'apc';
        }
        return 'file';
    }
    public function check_status()
    {
        $under_maintenance = false;
        if(file_exists(FCPATH . 'flags/.maintenance_mode')) {
            $under_maintenance = true;
        } else {
            $under_maintenance = $this->CI->db
                ->select('option_key')
                ->where([
                    'option_key' => 'maintenance',
                    'value' => '1',
                    'type' => 'system'
                ])
                ->get('system_options');
            if($under_maintenance) {
                $under_maintenance = $under_maintenance->row();
            }
        }
        
        if($under_maintenance) {
            http_response_code(503);
            echo base64_decode('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');
            exit;
        }
    }
    public function session_tracker()
    {
        $this->CI->load->library('sessionmanager');
        $this->CI->sessionmanager->check();
    }
}
