<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
if (! function_exists('is_really_writable')) {
    /**
     * Tests for file writability
     *
     * is_writable() returns TRUE on Windows servers when you really can't write to
     * the file, based on the read-only attribute. is_writable() is also unreliable
     * on Unix servers if safe_mode is on.
     *
     * @throws Exception
     *
     * @codeCoverageIgnore Not practical to test, as travis runs on linux
     */
    function is_really_writable(string $file): bool
    {
        // If we're on a Unix server we call is_writable
        if (DIRECTORY_SEPARATOR === '/') {
            return is_writable($file);
        }

        /* For Windows servers and safe_mode "on" installations we'll actually
         * write a file then read it. Bah...
         */
        if (is_dir($file)) {
            $file = rtrim($file, '/') . '/' . bin2hex(random_bytes(16));
            if (($fp = @fopen($file, 'ab')) === false) {
                return false;
            }

            fclose($fp);
            @chmod($file, 0777);
            @unlink($file);

            return true;
        }

        if (! is_file($file) || ($fp = @fopen($file, 'ab')) === false) {
            return false;
        }

        fclose($fp);

        return true;
    }
}
if (!function_exists('emp_mapping_result')) {
    function emp_mapping_result($object = null, $behavior = null)
    {
        $mapping_result[] = array('objective' => 1, 'behavior' => 1, 'result' => "Unacceptable");
        $mapping_result[] = array('objective' => 1, 'behavior' => 2, 'result' => "Unacceptable");
        $mapping_result[] = array('objective' => 1, 'behavior' => 3, 'result' => "Unacceptable");
        $mapping_result[] = array('objective' => 1, 'behavior' => 4, 'result' => "Unacceptable");
        $mapping_result[] = array('objective' => 1, 'behavior' => 5, 'result' => "Unacceptable");

        for ($a = 2; $a <= 5; $a++) {
            $mapping_result[] = array('objective' => $a, 'behavior' => 1, 'result' => "Unacceptable");
        }

        for ($b = 2; $b <= 5; $b++) {
            $mapping_result[] = array('objective' => $b, 'behavior' => 2, 'result' => "Needs Improvement");
        }

        for ($c = 3; $c <= 5; $c++) {
            $mapping_result[] = array('objective' => 2, 'behavior' => $c, 'result' => "Needs Improvement");
        }

        for ($d = 3; $d <= 5; $d++) {
            $mapping_result[] = array('objective' => $d, 'behavior' => 3, 'result' => "Fully Effective");
        }

        $mapping_result[] = array('objective' => 3, 'behavior' => 4, 'result' => "Fully Effective");
        $mapping_result[] = array('objective' => 3, 'behavior' => 5, 'result' => "Fully Effective");
        $mapping_result[] = array('objective' => 4, 'behavior' => 4, 'result' => "Commendable");
        $mapping_result[] = array('objective' => 5, 'behavior' => 4, 'result' => "Commendable");
        $mapping_result[] = array('objective' => 4, 'behavior' => 5, 'result' => "Commendable");
        $mapping_result[] = array('objective' => 5, 'behavior' => 5, 'result' => "Exceptional");

        if ($object != null && $behavior != null) {
            foreach ($mapping_result as $key => $value) {
                if (($object == intval($value['objective'])) && ($behavior == intval($value['behavior']))) {
                    return $value['result'];
                }
            }
        } else {
            return "No Value Found";
        }
    }
}
if (!function_exists('get_public_holiday')) {
    function get_public_holiday($full_date,$shift_id)
    {
        $ci = &get_instance();
        $ci->db->select('payroll_holiday.holiday_name');
        $ci->db->join('payroll_holiday', 'payroll_holiday.payrl_holi_id=payroll_holiday_shift_wise.payrl_holi_id', 'left');

        $ci->db->where('payroll_holiday.start_date <=', $full_date);
        $ci->db->where('payroll_holiday.end_date   >=', $full_date);
        $ci->db->where('payroll_holiday_shift_wise.shift_id',$shift_id);
        return $ci->db->get('payroll_holiday_shift_wise')->first_row();
            
    }
}
if (!function_exists('get_document_fields')) {
    function get_document_fields($id)
    {
        $ci = &get_instance();
        $ci->load->database();

        $ci->db->select("
            d.department_name
        ")
            ->from('employee_document_fields df')
            ->join('department d', 'df.department_id = d.dept_id');
        $ci->db->order_by('d.department_name', 'asc');
        $ci->db->where("df.employee_document_id", $id);

        return $ci->db->get()->result();
    }
}

if (!function_exists('print_rr')) {
    function print_rr($data = [])
    {
        echo '<pre>' . print_r($data, true) . '</pre>';
    }
}
if (!function_exists('secondsToTime')) {
    function secondsToTime($seconds)
    {
        if (empty($seconds)) {
            return [
                'hours' => 0,
                'minutes' => 0,
                'seconds' => 0,
            ];
        }
        $dtF = new DateTime('@0');
        $dtT = new DateTime("@$seconds");
        $dtT = $dtF->diff($dtT);
        return [
            'hours' => intval($dtT->format('%h')) + (intval($dtT->format('%a')) * 24),
            'minutes' => intval($dtT->format('%i')),
            'seconds' => intval($dtT->format('%s')),
        ];
    }
}
if (!function_exists('get_weekend')) {
    function get_weekend()
    {
        $ci =& get_instance();
        if(!$data = $ci->cache->get('application.weekend.by.shift')) {
            $weekend_days = getByWhereAsArray('weekly_holiday', '*');
            $res = [];
            foreach ($weekend_days as $wk_h) {
                $res[$wk_h['shift_id']] = explode(',', $wk_h['dayname']);
            }
            $ci->cache->save('application.weekend.by.shift', $res, 500);
            return $res;
        }
        return $data;
    }
}

if (!function_exists('daysBetween')) {
    function daysBetween($dt1, $dt2)
    {
        return date_diff(date_create($dt2), date_create($dt1))->format('%a') + 1;
    }
}

if(!function_exists('get_js_date_format')){
    function get_js_date_format()
    {
        return get_default_date_format('js-date');
    }
}
if(!function_exists('get_default_date_format')) {
    function get_default_date_format($type)
    {
        switch ($type) {
            case 'date': {
                return 'd-m-Y';
            }
            case 'time': {
                return 'h:i:s A';
            }
            case 'datetime': {
                return 'd-m-Y h:i:s A';
            }
            case 'regex-date': {
                return '#^[0-9]{2}-[0-9]{2}-[0-9]{4}$#';
            }
            case 'regex-time': {
                return '#^[0-9]{2}:[0-9]{2}:[0-9]{2}\s[a-z]{2}$#i';
            }
            case 'regex-datetime': {
                return '#^[0-9]{2}-[0-9]{2}-[0-9]{4}\s[0-9]{2}:[0-9]{2}:[0-9]{2}\s[a-z]{2}$#i';
            }
            case 'js-date': {
        return 'dd-mm-yy';
    }
            case 'js-time': {
                return 'h:m:s A';
}
            case 'js-datetime': {
                return 'dd-mm-yy h:m:s A';
            }
        }
        return null;
    }
}
if(!function_exists('formatted_date')){
    function formatted_date($date_string = '', $time = false)
    {
        $format = 'd-m-Y';
        if($time){
            $format .= ' h:i:s A';
        }
        if(empty($date_string) || $date_string == '0000-00-00'){
            return '';
        }else{
            return date($format, strtotime($date_string));
        }
    }
}
if(!function_exists('formatted_date_now')){
    function formatted_date_now($date_string = '', $time = false)
    {
        $format = 'd-m-Y';
        if($time){
            $format .= ' h:i:s A';
        }
        if(empty($date_string) || $date_string == '0000-00-00'){
            return date($format);
        }else{
            return date($format, strtotime($date_string));
        }
    }
}
if (!function_exists('formatted_time_now')) {
    function formatted_time_now($time_string = '', $time = false)
    {
        $format = 'h:i:s A';
        if (empty($time_string) || $time_string == '00:00:00') {
            return date($format);
        } else {
            return date($format, strtotime($time_string));
        }
    }
}
if (!function_exists('formatted_time')) {
    function formatted_time($time_string = '', $time = false)
    {
        $format = 'h:i:s A';
        if (empty($time_string) || $time_string == '00:00:00') {
            return '';
        } else {
            return date($format, strtotime($time_string));
        }
    }
}

if(!function_exists('slug_to_readable')){
    function slug_to_readable($str)
    {
        $str = str_replace(['_', '-'], ' ', $str);
        return ucwords($str);
    }
}
if (!function_exists('text_to_slug')) {
    function text_to_slug($str)
    {
        return preg_replace('~[^\w\d]+~', '_', trim($str));
    }
}

if(!function_exists('convert_excel_date')){
    function convert_excel_date($date, $format = 'Y-m-d')
    {
        if(empty(trim($date))){
            return null;
        }
        $date = preg_replace('#\D#is', '/', $date);
        $src_fmt = 'd/m/Y';
        if(strlen($date) == 8){
            $src_fmt = 'd/m/y';
        }
        $datetime = DATETIME::createFromFormat($src_fmt, $date);
        return $datetime ? $datetime->format($format) : '';
    }
}
if(!function_exists('first_or_second')){
    function first_or_second($type, $item1, $item2)
    {
        return $type ? $item1 : $item2;
    }
}

if(!function_exists('generate_hrm_id')){
    function generate_hrm_id($division_id = null)
    {
        $CI = get_instance();
        if(empty($division_id)) {
            $division_id = $CI->session->userdata('division_id');
        }
        if($division_id) {
            $division_id = $CI->db->where('id', $division_id)->get('divisions')->row();
        }
        $rec = $CI->db->where('division_id', $division_id->id)->get('hrm_ids')->row();
        $hrm_num = 0;
        if(!$rec) {
            $CI->db->insert('hrm_ids', [
                'division_id' => $division_id->id,
                'hrm_id' => 0
            ]);
        } else {
            $hrm_num = $rec->hrm_id;
        }
        do {
            $hrm_num++;
            $hrm_id = $division_id->prefix . '-' . str_pad($hrm_num, 4, '0', STR_PAD_LEFT);
            $hrm_exists = $CI->db->where('hrm_id', $hrm_id)->get('employee_history')->row();
            if($hrm_exists) {
                $CI->db->where('division_id', $division_id->id)->update('hrm_ids', [
                    'hrm_id' => $hrm_num
                ]);
            }
        } while ($hrm_exists);
        return str_pad($hrm_num, 4, '0', STR_PAD_LEFT);
    }
}

if(!function_exists('increment_hrm_id')) {
    function increment_hrm_id($division_id, $hrm_id)
    {
        $CI =& get_instance();
        $rec = $CI->db->where('division_id', $division_id)->get('hrm_ids')->row();
        if(abs($rec->hrm_id - $hrm_id) === 1) {
            $CI->db->where('division_id', $division_id)->update('hrm_ids', [
                'hrm_id' => $hrm_id
            ]);
        }
    }
}

if(!function_exists('encrypt_employee_data')){
    function encrypt_employee_data($data, $additional_cols = [], $table = 'employee_history')
    {
        $CI = get_instance();
        $cols_to_encrypt = $CI->config->item('encrypted_columns')[$table];
        $cols_to_encrypt = array_merge($cols_to_encrypt, $additional_cols);
        $is_array = is_array($data);
        $data = $is_array ? $data : (array) $data;
        foreach ($data as $col_key => $col_value) {
            if(in_array($col_key, $cols_to_encrypt) && !empty($col_value)){
                $data[$col_key] = $CI->encryption->encrypt($col_value);
            }
        }
        return $is_array ? $data : (object) $data;
    }
}

if(!function_exists('decrypt_employee_data')){
    function decrypt_employee_data($data, $additional_cols = [], $bypass = false, $table = 'employee_history')
    {
        $CI = get_instance();
        $cols_to_decrypt = $CI->config->item('encrypted_columns')[$table];
        $still_encrypted = [];

        if(!$bypass) {
            if(!($CI->permission->method('employee_salary_permission', 'read')->access() || $CI->permission->method('employee_salary_permission', 'update')->access())){
                $still_encrypted = $CI->config->item('encrypted_salary_columns')[$table];
            }
        }
        $cols_to_decrypt = array_filter($cols_to_decrypt, function($val) use ($still_encrypted) {
            return !in_array($val, $still_encrypted);
        });
        $cols_to_decrypt = array_merge($cols_to_decrypt, $additional_cols);
        $is_array = is_array($data);
        $data = $is_array ? $data : (array) $data;
        foreach ($data as $col_key => $col_value) {
            if(in_array($col_key, $cols_to_decrypt) && !empty($col_value)){
                $data[$col_key] = $CI->encryption->decrypt($col_value);
            }
            if(in_array($col_key, $still_encrypted)) {
                $data[$col_key] = '[Encrypted]';
            }
        }
        return $is_array ? $data : (object) $data;
    }

}
if(!function_exists('can_decrypt_employee_column')){
    function can_decrypt_employee_column($col_name, $table = 'employee_history')
    {
        $CI = get_instance();        
        $cols_to_decrypt = $CI->config->item('encrypted_columns')[$table];

        $cols_to_decrypt2 = [];

        foreach ($cols_to_decrypt as $col) {
            $cols_to_decrypt2[$col] = true;
        }
        if(!($CI->permission->method('employee_salary_permission', 'read')->access() || $CI->permission->method('employee_salary_permission', 'update')->access())){
            $sal_perms = $CI->config->item('encrypted_salary_columns')[$table];
            foreach ($sal_perms as $sal_perm) {
                $cols_to_decrypt2[$sal_perm] = false;
            }
        }
        return !isset($cols_to_decrypt2[$col_name]) ||  $cols_to_decrypt2[$col_name];
    }

}
function encode_img_base64($img_path = false, $img_type = 'png')
{
    if( $img_path ){
        //convert image into Binary data
        $img_data = fopen ( $img_path, 'rb' );
        $img_size = filesize ( $img_path );
        $binary_image = fread ( $img_data, $img_size );
        fclose ( $img_data );

        //Build the src string to place inside your img tag
        $img_src = "data:image/".$img_type.";base64,".str_replace ("\n", "", base64_encode($binary_image));

        return $img_src;
    }
	return false;
}

if (!function_exists('array_to_path')) {
    function array_to_path($arr)
    {
        return implode(DIRECTORY_SEPARATOR, $arr);
    }
}

//generate slug
if (!function_exists('str_slug')) {
    function str_slug($str)
    {
        return url_title(convert_accented_characters($str), "-", true);
    }
}

if (!function_exists('get_enum_values')) {
    function get_enum_values( $table, $field )
    {
        $CI =& get_instance();
        $cache_string = sprintf('enum_values.%s.%s', $table, $field);
        if(!$data = $CI->cache->get($cache_string)) {
        $type = $CI->db->query( "SHOW COLUMNS FROM {$table} WHERE Field = '{$field}'" )->row( 0 )->Type;
        preg_match("#^enum\(\'(.*)\'\)$#is", $type, $matches);
        $enums = explode("','", $matches[1]);
        $data = [];
        foreach ($enums as $enum) {
                $data[$enum] = slug_to_readable($enum);
        }
            $CI->cache->save($cache_string, $data, 900);
        }
        return $data;
    }
}

if(!function_exists('cnic_with_dashes')){
    function cnic_with_dashes($str, $combo = [5, 13])
    {
        $str = trim(strval($str));
        if(empty($str)){
            return '';
        }
        $str = substr_replace($str, '-', $combo[0], 0);
        $str = substr_replace($str, '-', $combo[1], 0);
        return $str;
    }
}

if(!function_exists('get_module_name')){
    function get_module_name(){
        return CI::$APP->router->fetch_module();
    }
}
if(!function_exists('month_first_last_day')){
    /**
     * Get first and last day of a month
     * 
     * 
     * @author Ahmed Raza ahmed.raza@proglobaltechnologies.com
     * @param int $month Month in numeric
     * @param int $year Year in numeric format
     * @return array Array containing first and last day of month
     * Example:
     * ```
     * month_first_last_day(); //Return first and last day of current month
     * month_first_last_day(1, 1980); //Return first and last day of January 1980
     * 
     * ```
     */
    function month_first_last_day($month = null, $year = null)
    {
        if(is_null($month)){
            $month = date('m');
        }
        if(is_null($year)){
            $year = date('Y');
        }
        $first = strtotime("{$year}-{$month}-01");
        
        $last = strtotime("{$year}-{$month}-01");
        $last = strtotime('+1 month', $last) - 1;

        return [
            'first' => date('Y-m-d', $first),
            'last' => date('Y-m-d', $last)
        ];
    }
}
if(!function_exists('last_day_of_month')){
    /**
     * Get last day of a month
     * 
     * @author Ahmed Raza ahmed.raza@proglobaltechnologies.com
     * @param int $month Month in numeric
     * @param int $year Year in numeric format
     * @return array Array containing first and last day of month
     * 
     * Example:
     * ```
     * last_day_of_month(); //Last day of current month
     * last_day_of_month(1, 1980); //Last day of January 1980
     * 
     * ```
     */
    function last_day_of_month($date = null)
    {
        if(is_null($date)){
            $date = date('Y-m-01');
        }
        $first = strtotime(date('Y-m-01', strtotime($date)));
        return date('Y-m-d', strtotime('+1 month', $first) - 1);
    }
}
if(!function_exists('interval_into_months')){
    /**
     * Divide a interval of days into months based intervals
     * 
     * @author Ahmed Raza ahmed.raza@proglobaltechnologies.com
     * @param string $start Start of period
     * @param string $end End of period
     * @return array Array containing associative months interval
     * 
     * Example:
     * ```
     * last_day_of_month('2021-01-23', '2021-03-12'); //Last day of current month
     * 
     * ```
     */
    function interval_into_months($start, $end)
    {
        $processed = [];
        
        $start = strtotime($start);
        $end = strtotime($end);

        while( $start <= $end ) {
            $month = date('Y-m-01', $start);
            if(!isset($processed[$month])) {
                $processed[$month] = [];
            }
            $processed[$month][] = date('Y-m-d', $start);
            $start = strtotime('+1 day', $start);
        }
        return $processed;
    }
}
if(!function_exists('interval_into_years')){
    /**
     * Divide a interval of days into year based intervals
     * 
     * @author Ahmed Raza ahmed.raza@proglobaltechnologies.com
     * @param string $start Start of period
     * @param string $end End of period
     * @return array Array containing associative months interval
     * 
     * Example:
     * ```
     * last_day_of_month('2021-01-23', '2021-03-12'); //Last day of current month
     * 
     * ```
     */
    function interval_into_years($start, $end)
    {
        $years = range(
            (int) date('Y', strtotime($start)),
            (int) date('Y', strtotime($end))
        );
        sort($years);
        return $years;
    }
}
if(!function_exists('sql_date')){
    function sql_date($date, $time = false)
    {
        $fmt = 'Y-m-d';
        if($time){
            $fmt .= ' H:i:s';
        }
        return date($fmt, strtotime($date));
    }
}
if(!function_exists('array_diff_multi')){
    function array_diff_multi($old, $new, $key)
    {
        $data['added'] = array_udiff($new, $old, function($a, $b) use ($key)
        {
            return $a[$key] <=> $b[$key];
        });
        $data['removed'] = array_udiff($old, $new, function($a, $b) use ($key)
        {
            return $a[$key] <=> $b[$key];
        });
        return $data;
    }
}
if(!function_exists('file_time_append')) {
    function file_time_append($filename)
    {
        $CI =& get_instance();
        $CI->load->helper('string');
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        $name = pathinfo($filename, PATHINFO_FILENAME);

        return $name.'-' . random_string('alnum', 4) .time().'.'.$ext;
    }
}
if(!function_exists('current_date')) {
    function current_date($time = false)
    {
        $fmt = 'Y-m-d';
        if($time) {
            $fmt .= ' H:i:s';
        }
        return date($fmt);
    }
}
if(!function_exists('isEmptyArray')) {
    function isEmptyArray($arr = [])
    {
        if(!is_array($arr)) {
            return null;
        }
        foreach ($arr as $value) {
            if(!empty(trim(strval($value)))) {
                return false;
            }
        }
        return true;
    }
}
if(!function_exists('get_settings')) {
    function get_settings()
    {
        $ci =& get_instance();
        $ci->load->database();
        if(!$data = $ci->cache->get('application.setting')) {
            $settings = $ci->db->get('setting')->row();
            $ci->cache->save('application.setting', $settings, 900);
            return $settings;
        }
        return $data;
    }
}
if(!function_exists('percentage_to_amount')) {
    function percentage_to_amount($amount, $percentage)
    {
        if(!$amount) {
            return 0;
        }
        return ($amount * ($percentage / 100));
    }
}
if(!function_exists('user_option')) {
    function user_option($key, $check_value = null)
    {
        $value = $_SESSION['user_options'][$key];
        if(!$value) {
            return false;
        }
        if($check_value) {
            return $value == $check_value;
        }
        return $value;
    }
}
if(!function_exists('get_ip_address')) {
    function get_ip_address()
    {
        $ipaddress = '';
        if (isset($_SERVER["HTTP_CF_CONNECTING_IP"])) {
            $ipaddress = $_SERVER["HTTP_CF_CONNECTING_IP"];
        } elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        } else if (isset($_SERVER['HTTP_FORWARDED'])) {
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        } else if (isset($_SERVER['REMOTE_ADDR'])) {
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        } else {
            $ipaddress = 'UNKNOWN';
        }

        return $ipaddress;
    }
}
if(!function_exists('displayGraphicFile')) {
    function displayGraphicFile($file)
    {
        $CI =& get_instance();
        $fileModTime = filemtime($file);
        $file_meta = getimagesize($file);
        $header = $CI->input->get_request_header('If-Modified-Since');

        header("Cache-Control: must-revalidate");
        if ($header && (strtotime($header) == $fileModTime)) {
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $fileModTime) . ' GMT', true, 304);
        } else {
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $fileModTime) . ' GMT', true, 200);
            header('Content-type: ' . $file_meta['mime']);
            header('Content-transfer-encoding: binary');
            header('Content-length: ' . filesize($file));
            readfile($file);
        }
        exit;
    }
}
if(!function_exists('date_range')) {
    /**
     * Creating date collection between two dates
     *
     * <code>
     * <?php
     * # Example 1
     * date_range("2014-01-01", "2014-01-20", "+1 day", "m/d/Y");
     *
     * # Example 2. you can use even time
     * date_range("01:00:00", "23:00:00", "+1 hour", "H:i:s");
     * </code>
     *
     * @author Ali OYGUR <alioygur@gmail.com>
     * @param string since any date, time or datetime format
     * @param string until any date, time or datetime format
     * @param string step
     * @param string date of output format
     * @return array
     */
    function date_range($first, $last, $step = '+1 day', $output_format = 'd/m/Y' ) {

        $dates = array();
        $current = strtotime($first);
        $last = strtotime($last);

        while( $current <= $last ) {

            $dates[] = date($output_format, $current);
            $current = strtotime($step, $current);
        }

        return $dates;
    }
}
if(!function_exists('writepath_uri')) {
    function writepath_uri()
    {
        $CI =& get_instance();
        if(!$data = $CI->cache->get('write_path_uri')) {
            $data = str_replace(['/', '\\'], '/', str_replace(FCPATH, '', WRITEPATH));
            $CI->cache->save('write_path_uri', $data, 200);
        }
        return $data;
    }
}
if(!function_exists('calculate_income_tax')) {
    /**
    * Calculate income tax on provided monthly value
    *
    * <code>
    * <?php
    * # Example 1
    * calculate_income_tax(60000);
    * </code>
    *
    * @author Ahmed Raza <ahmed.raza@proglobaltechnologies.com>
    * @param integer Monthly Income
    * @return integer Monthly Tax
    * @throws Exception when slab doesn't match
    */
    function calculate_income_tax($monthly_salary)
    {
        $monthly_salary = intval($monthly_salary);
        if(!$monthly_salary || $monthly_salary < 0) {
            return 0;
        }
        $yearly = $monthly_salary * 12;
        $ci =& get_instance();
        if(!$slabs = $ci->cache->get('application.tax.slabs')) {
            $slabs = getByWhereAsArray('payroll_tax_slabs', '*', [], ['rate', 'asc']);
            $ci->cache->save('application.tax.slabs', $slabs, strtotime('+1 hour', 0));
        }
        $slab = null;
        foreach ($slabs as $sl) {
            if($sl['min'] <= $yearly && $yearly <= $sl['max']) {
                $slab = $sl;
                break;
            }
        }
        if(!$slab) {
            throw new Exception("Slab Not Found for amount ${$monthly_salary}");
        }
        $tax = 0;
        if($slab['fixed'] > 0) {
            $tax += $slab['fixed'];
        }
        $tax += (($yearly - $slab['min'] - 1) * ($slab['rate'] / 100));
        $tax /= 12;

        return round($tax);
    }
}
if(!function_exists('get_all_divisions')) {
    function get_all_divisions()
    {
        $ci =& get_instance();
        if(!$data = $ci->cache->get('application.divisions.all')) {
            $data = getByWhere('divisions', 'id, name', [], ['name', 'asc']);
            $ci->cache->save('application.divisions.all', $data, 120);
            return $data;
        }
        return $data;
    }
}
if(!function_exists('get_all_departments')) {
    function get_all_departments()
    {
        $ci =& get_instance();
        if(!$data = $ci->cache->get('application.departments.all')) {
            $data = getByWhere('department', 'dept_id as id, department_name as name', [], ['department_name', 'asc']);
            $ci->cache->save('application.departments.all', $data, 120);
            return $data;
        }
        return $data;
    }
}
if(!function_exists('get_all_employees')) {
    function get_all_employees()
    {
        $ci =& get_instance();
        if(!$data = $ci->cache->get('application.employees.all')) {
            $data = getByWhere('employee_history', 'employee_id as id, CONCAT_WS(\' \', first_name, last_name) as name', [], ['first_name', 'asc']);
            $ci->cache->save('application.employees.all', $data, 120);
            return $data;
        }
        return $data;
    }
}
if(!function_exists('addOrdinalNumberSuffix')){
    function addOrdinalNumberSuffix($num) {
        if (!in_array(($num % 100),array(11,12,13))){
            switch ($num % 10) {
            // Handle 1st, 2nd, 3rd
            case 1:  return $num.'st';
            case 2:  return $num.'nd';
            case 3:  return $num.'rd';
            }
        }
        return $num.'th';
    }
}
if(!function_exists('calculate_eobi')) {
    function calculate_eobi($amount, $hire_date, $termination_date = null, $training_period = 0)
    {
        if($termination_date == '0000-00-00') {
            $termination_date = null;
        }
        if(!$termination_date) {
            $termination_date = date('Y-m-d');
        }
        if($training_period > 0) {
            $hire_date = date('Y-m-d', strtotime('+' . $training_period . ' days'));
        }
        if(strtotime($hire_date) == strtotime($termination_date)) {
            return 0;
        }
        $days_in_month = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($termination_date)), date('Y', strtotime($termination_date)));
        $days = daysBetween($hire_date, $termination_date);
        if($days < $days_in_month) {
            return round(($amount / $days_in_month) * $days);
        }
        return $amount;
    }
}
if(!function_exists('highest_date')) {
    function highest_date($date1, $date2)
    {
        return strtotime($date1) > strtotime($date2) ? $date1 : $date2;
    }
}
if(!function_exists('calculate_gross_salary')) {
    function calculate_gross_salary($employee_id, $start = null, $end = null, $bypass_encryption = false)
    {
        if(!$bypass_encryption && !can_decrypt_employee_column('hired_salary')) {
            return '[ENCRYPTED]';
        }
        $ci =& get_instance();

        if(!$start && !$end) {
            $temp = month_first_last_day();
            $start = $temp['first'];
            $end = $temp['last'];
        } elseif (!$end) {
            $temp = month_first_last_day(date('m', strtotime($start)), date('Y', strtotime($start)));
            $start = $temp['first'];
            $end = $temp['last'];
        } else {
            $start = sql_date($start);
            $end = sql_date($end);
        }

        $cache_string = sprintf('gs.calc.%s.%s.%s', $employee_id, $start, $end);
        if(!$data = $ci->cache->get($cache_string)) {
            $employee = $ci->db->select('hired_salary')->where('employee_id', $employee_id)->get('employee_history')->row();
            $hired_salary = floatval($ci->encryption->decrypt($employee->hired_salary));
            $old_increments = $ci->db->select('amount')->where(['employee_id' => $employee_id, 'date <' => $start])->get('employee_increments')->result();
            $old_increments = array_reduce($old_increments, function($sum, $v) use ($ci) {
                return $sum += floatval($ci->encryption->decrypt($v->amount));
            }, 0);
            $old_gross = $hired_salary + $old_increments;

            $current_increments = $ci->db->select('amount, date')->where(['employee_id' => $employee_id, 'date >=' => $start, 'date <=' => $end])->order_by('date', 'asc')->get('employee_increments')->result();
            $current_increments = array_map(function($v) {
                return decrypt_employee_data($v, [], true, 'employee_increments');
            }, $current_increments);

            $remaining_days = daysBetween($start, $end);
            $current_start = $start;
            $current_gross = 0;
            while (count($current_increments) > 0) {
                $current_increment = array_shift($current_increments);

                $current_days = daysBetween($current_start, $current_increment->date) - 1;
                $per_day = get_per_day_salary($old_gross, $current_start);

                $current_gross += ($per_day * $current_days);

                $remaining_days -= $current_days;
                $current_start = $current_increment->date;

                $old_gross += $current_increment->amount;
            }

            $per_day = get_per_day_salary($old_gross, $current_start);
            $current_gross += ($per_day * $remaining_days);

            $current_gross = round($current_gross);
            $ci->cache->save($cache_string, $ci->encryption->encrypt($current_gross), 10);
            return $current_gross;
        }
        return $ci->encryption->decrypt($data);
    }
}
if(!function_exists('get_per_day_salary')) {
    function get_per_day_salary($gross, $date = null)
    {
        if(!$date) {
            $date = date('Y-m-d');
        }
        $days = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($date)), date('Y', strtotime($date)));

        return $gross / $days;
    }
}
if(!function_exists('getWeekdayDifference')){
    function getWeekdayDifference($shift_id, $startDate, $endDate)
    {
        $weekends = get_weekend();

        $startDate = new DateTime($startDate);
        $endDate = new DateTime($endDate);
        $endDate = $endDate->add(new DateInterval("P1D"));

        $days = 0;
        while($startDate->diff($endDate)->days > 0) {
            if(!in_array($startDate->format('l'), $weekends[$shift_id])) {
                $days++;
            }
            $startDate = $startDate->add(new DateInterval("P1D"));
        }

        return $days;
    }
}

if(!function_exists('getWeekdayPeriod')){
    function getWeekdayPeriod($shift_id, $days_to_add, $startDate = null)
    {
        $weekends = get_weekend();

        $endDate = new DateTime($startDate);

        $days = 0;
        do {
            if(!in_array($endDate->format('l'), $weekends[$shift_id] ?? [])) {
                $days++;
            }
            if($days >= $days_to_add) {
                break;
            }
            $endDate = $endDate->add(new DateInterval("P1D"));
        } while($days < $days_to_add);

        return [
            'start' => $startDate ?? date('Y-m-d'),
            'end' => $endDate->format('Y-m-d')
        ];
    }
}

if(!function_exists('getAge')){
    function getAge($birthdate) {
        $birthdate = new DateTime($birthdate);
        $today     = new DateTime();
        $interval  = $today->diff($birthdate);
        return intval($interval->format('%y'));
    }
}
if(!function_exists('current_working_day')) {
    function current_working_day($day = null, $time = true)
    {
        if(!$day) {
            $day = date('Y-m-d H:i:s');
        }
        $ci =& get_instance();
        $first_shift_diff = $ci->db->query(
            'CALL get_shift_start(?)',
            [$day]
        )->row();
        $ci->db->next_result();
        if(!$first_shift_diff) {
            return null;
        }
        if(!$time) {
            return date('Y-m-d', strtotime($first_shift_diff->day_start));
        }
        return $first_shift_diff->day_start;
    }
}
if(!function_exists('delete_directory')) {
    function delete_directory($dir)
    {
        $files = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS),
            RecursiveIteratorIterator::CHILD_FIRST
        );
        
        foreach ($files as $fileinfo) {
            $todo = ($fileinfo->isDir() ? 'rmdir' : 'unlink');
            $todo($fileinfo->getRealPath());
        }
        
        rmdir($dir);
    }
}
if(!function_exists('month_labels')) {
    function month_labels()
    {
        $data = [];
        for ($i=1; $i <= 12; $i++) { 
            $data[$i] = date('F', mktime(0, 0, 0, $i));
        }
        return $data;
    }
}
if(!function_exists('get_random_employee')) {
    function get_random_employee($limit = 1)
    {
        $ci =& get_instance();
        return $ci->db->select('hrm_id, employee_id, first_name, last_name')->limit($limit)->order_by('Rand()', '', false)->get('employee_history')->result_array();
    }
}
if(!function_exists('is_mobile_device')) {
    function is_mobile_device() {
        return preg_match('/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i',$_SERVER['HTTP_USER_AGENT'])||preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i',substr($_SERVER['HTTP_USER_AGENT'],0,4));
    }
}
if(!function_exists('bytes_to_words')) {
    function bytes_to_words($bytes) {
        if ($bytes > 0) {
          $base = floor(log($bytes) / log(1000));
          $units = array("B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"); //units of measurement
          return number_format(($bytes / pow(1000, floor($base))), 2) . " $units[$base]";
        } else return "0 bytes";
    }
}
if(!function_exists('flatten_sidebar')) {
    function flatten_sidebar(array $array)
    {
        $return = array();
        foreach ($array as $arr) {
            if($arr['items']) {
                $arr = $arr['items'];
            }
            if($arr['controller']) {
                $return[] = $arr;
            } else {
                $arr = flatten_sidebar($arr);
                $return = array_merge($return, $arr);
            }
        }
        return $return;
    }
}
if(!function_exists('get_division_domain')) {
    function get_division_domain($division_id)
    {
        $ci =& get_instance();
        if(!$domain = $ci->cache->get('application.division.domain')) {
            $rec = $ci->db->select('url')->where('id', $division_id)->get('divisions')->row();
            $domain = $rec->url;
            $ci->cache->save('application.division.domain', $domain, 7200);
        }
        return $domain;
    }
}
if(!function_exists('is_windows_server')) {
    function is_windows_server()
    {
        return stripos(PHP_OS, 'WIN') === 0;
    }
}