<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\UserModel;

class User extends BaseController
{
    public function login()
    {
        $data = [];

        if ($this->request->getMethod() == 'post') {

            $rules = [
              'email' => 'required|min_length[6]|max_length[50]|valid_email',
              'password' => 'required|min_length[8]|max_length[255]|validateUser[email,password]',
            ];

            $errors = [
                'password' => [
                    'validateUser' => "Email or Password don't match",
                ],
            ];

            if (!$this->validate($rules, $errors)) {

                return view('login', [
                    "validation" => $this->validator,
                ]);

            } else {
                $model = new UserModel();
                $user = $model->where('email', $this->request->getVar('email'))
                    ->first();

                // Stroing session values
                $this->setUserSession($user);
                // Redirecting to dashboard after login
                return redirect()->to(base_url('collections'));

            }
        }
        return view('login');
    }

    private function setUserSession($user)
    {
        $data = [
            'id' => $user['id'],
            'name' => $user['name'],
            'phone_no' => $user['phone_no'],
            'email' => $user['email'],
            'isLoggedIn' => true,
        ];

        session()->set($data);
        return true;
    }

    public function register()
    {
        $data = [];

        if ($this->request->getMethod() == 'post') {
            //let's do the validation here
            $rules = [
                'name' => 'required|min_length[3]|max_length[20]',
                'phone_no' => 'required|min_length[9]|max_length[20]',
                'email' => 'required|min_length[6]|max_length[50]|valid_email|is_unique[users.email]',
                'password' => 'required|min_length[8]|max_length[255]',
                'password_confirm' => 'matches[password]',
            ];

            if (!$this->validate($rules)) {

                return view('register', [
                    "validation" => $this->validator,
                ]);
            } else {
                $model = new UserModel();
				$options=['cost'=>11];
                $newData = [
                    'name' => $this->request->getVar('name'),
                    'phone_no' => $this->request->getVar('phone_no'),
                    'email' => $this->request->getVar('email'),
                    'password' => password_hash($this->request->getVar('password'),PASSWORD_BCRYPT,$options),
                ];
                $model->save($newData);
                $session = session();
                $session->setFlashdata('success', 'Successful Registration');
                return redirect()->to(base_url('login'));
            }
        }
        return view('register');
    }

    public function profile()
    {

        $data = [];
        $model = new UserModel();

        $data['user'] = $model->where('id', session()->get('id'))->first();
        return view('profile', $data);
    }

    public function rest_password(){
    	 $data = [];

        if ($this->request->getMethod() == 'post') {
            //let's do the validation here
            $rules = [
                'password' => 'required|min_length[8]|max_length[255]',
                'password_confirm' => 'matches[password]',
            ];

            if (!$this->validate($rules)) {

                // return view('profile', [
                //     "validation" => $this->validator,
                // ]);


                $data = [];
		        $model = new UserModel();

		        $data['user'] = $model->where('id', session()->get('id'))->first();
		        $data["validation"] = $this->validator;
		        return view('profile', $data);

            } else {
                $model = new UserModel();
				$options=['cost'=>11];
                // $newData = [
                //     'password' => password_hash($this->request->getVar('password'),PASSWORD_BCRYPT,$options),
                // ];

  				$session = session();
             	$id = $session->get('id');
             	$model->set('password', password_hash($this->request->getVar('password'),PASSWORD_BCRYPT,$options));
				$model->where('id', $id);
				$model->update();

                // $model->save($newData);
              
                $session->setFlashdata('success', 'Password updated successfully!');
                return redirect()->to(base_url('profile'));
            }
        }
        return view('register');
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to('login');
    }
}