<?php

namespace App\Models;

use CodeIgniter\Model;

class TargetAllotmentsModel extends Model
{
    // MLM_Dim_Sheet
	protected $DBGroup              = 'default';
// 	protected $table                = 'date_table';
	protected $primaryKey           = 'id';
	protected $useAutoIncrement     = true;
	protected $insertID             = 0;
	protected $returnType           = 'array';
	protected $useSoftDelete        = false;
	protected $protectFields        = true;
	protected $allowedFields        =  array('*');
	// Dates
	protected $useTimestamps        = false;
	protected $dateFormat           = 'datetime';
	protected $createdField         = 'created_at';
	protected $updatedField         = 'updated_at';
	protected $deletedField         = 'deleted_at';

	// Validation
	protected $validationRules      = [];
	protected $validationMessages   = [];
	protected $skipValidation       = false;
	protected $cleanValidationRules = true;

	// Callbacks
	protected $allowCallbacks       = true;
	protected $beforeInsert         = [];
	protected $afterInsert          = [];
	protected $beforeUpdate         = [];
	protected $afterUpdate          = [];
	protected $beforeFind           = [];
	protected $afterFind            = [];
	protected $beforeDelete         = [];
	protected $afterDelete          = [];

	public function target_departments($table_name,$month){
		return $this->db->table($table_name)->select('*')->where("Date", $month)->get()->getResult();
	}

	public function delete_targets($table,$ID){
		return $this->db->table($table)->whereIn('ID',$ID)->delete();
	}

	public function target_pending_cancelled($table,$date,$ID){
		return $this->db->table($table)->select('EMP_ID')->where('Date',$date)->whereIn('Target_Status',['0','2'])->whereIn('ID',$ID)->get()->getResult();
	}

	public function insert_records($table,$data){
		return $this->db->table($table)->insert($data);	
	}
	
	public function updateEmailStatus($Departments,$id,$empID){
		$table       = 'allot_'.$Departments;
		$email_token = md5($empID);
		$this->db->query('update '.$table.' set Email_Sent = (Email_Sent+1), Email_Token = "'.$email_token.'" where ID = '.$id)->getResult();
		return  $this->db->query('select Email_Sent from '.$table.'  where ID = '.$id)->getResult();
	}

}
