<?php
function modules_data()
{
    $db = \Config\Database::connect();
    $result = $db->table('modules')->select('*')->get()->getResult();
    return $result;
}
function check_perm($segment1, $segment2 = null, $permission)
{
    $all_permissions = session()->get('roles_permission');
    $access = 0;
    if (session()->get('id') == 1) {
        $access = 1;
    } else {
        foreach ($all_permissions as $key => $value) {
            if ($segment1 == $value->parent && $segment2 == "" && $value->{$permission} == 1) {
                $access = 1;
            } else if (isset($segment2) && $segment2 == $value->url && $value->{$permission} == 1) {
                $access = 1;
            }
        }
    }
    return $access;
}
function generate_csv($data, $fileName)
{
    // $data = generate($tables, $columns, $where);
    header('Content-Description: File Transfer');
    header('Content-Type: text/x-comma-separated-values');
    header('Content-Disposition: attachment; filename=' . $fileName);
    header('Content-Transfer-Encoding: binary');
    $f = fopen('php://output', 'w');
    fwrite($f, chr(0xEF) . chr(0xBB) . chr(0xBF));
    fputcsv($f, $data->header);
    $i = 1;
    foreach ($data->row as $row) {
        fputcsv($f, (array) $row);
        $i++;
    }
    exit;
}
function tables_fields_count($table_name, $unset_array, $count = null)
{
    $db = \Config\Database::connect();
    $table_descriptions = $db->query('describe ' . $table_name)->getResult();
    $table_fields_count = 0;
    $table_fields = [];
    if ($table_descriptions) {
        foreach ($table_descriptions as $key => $value) {
            if (!in_array($value->Field, $unset_array)) {
                $table_fields_count++;
                $table_fields[] = $value->Field;
            }
        }
    }
    if (isset($count)) {
        return $table_fields_count;
    } else {
        return $table_fields;
    }
}
function sheet_fields_count($sheet_array)
{
    $sheet_count = 0;
    if ($sheet_array) {
        foreach ($sheet_array as $key => $value) {
            if ($value) {
                $sheet_count++;
            }
        }
    }
    return $sheet_count;
}
function encode_img_base64($img_path = false, $img_type = 'png')
{
    if ($img_path) {
        //convert image into Binary data
        $img_data = fopen($img_path, 'rb');
        $img_size = filesize($img_path);
        $binary_image = fread($img_data, $img_size);
        fclose($img_data);
        //Build the src string to place inside your img tag
        $img_src = "data:image/" . $img_type . ";base64," . str_replace("\n", "", base64_encode($binary_image));
        return $img_src;
    }
    return false;
}
function holiday_check()
{
    $db = \Config\Database::connect();
    $result = $db->table('modules')->select('*')->get()->getResult();
    return $result;
}
function check_import_month($department, $value, $selected_date)
{
    $result = false;
    if ($department == 'wc_collection' || $department == 'mlcr_collection') {
        $insert_start_date = date('Y-m', strtotime($value['10']));
        $insert_end_date = date('Y-m', strtotime($value['11']));
        if ($insert_start_date != $selected_date && $insert_end_date != $selected_date) {
            $result = true;
        }
    }
    return $result;
}
function monthly_calendar($date, $daily = '', $weekly = '', $total = '', $fulldate = '', $dateStart = '', $dateEnd = '', $color = '', $shift)
{
    $daily = floatval(preg_replace('#[^\w\d\.]#', '', $daily));
    date_default_timezone_set('Asia/Karachi');
    $holiday_date = [];
    foreach ($shift as $key => $value) {
        $explod_date = explode(',', $value->holiday_date);
        $dates = [];
        $dates['start'] = date('Y-m-d', strtotime($explod_date[0]));
        $dates['end'] = date('Y-m-d', strtotime($explod_date[1]));
        $holiday_date[] = $dates;
    }
    if (isset($date)) {
        $ym = $date;
    } else {
        $ym = date('Y-m');
    }
    $timestamp = strtotime($ym . '-01');
    $date_start = date('Y-m-d', strtotime($dateStart));
    $date_end = date('Y-m-d', strtotime($dateEnd));
    if ($timestamp === false) {
        $ym = date('Y-m');
        $timestamp = strtotime($ym . '-01');
    }
    $day_count = date('t', $timestamp);
    $str = date('N', $timestamp);
    $weeks = [];
    $week = '';
    $data_week = '';
    $pre_month = date('Y-m-d', strtotime('-1 months', $timestamp));
    $next_month = date('Y-m', strtotime('+1 months', $timestamp));
    $pre_month_days = date('t', strtotime(date('Y-m-d', strtotime('-1 months', $timestamp))));
    $empty_start_days = $str - 1;
    $remaing_days = $pre_month_days - $empty_start_days;
    for ($jk = $remaing_days + 1; $jk <= $pre_month_days; $jk++) {
        $week .= '<td style="text-align:center;font-size:12px;padding: 2px 0;">' . $jk . '</td>';
    }
    $data_week .= str_repeat('<td ></td>', $str - 1);
    // $week_days =1 ;
    $k = 0;
    $weekly_amount = 0;
    $monthly_target = 0;
    for ($day = 1; $day <= $day_count; $day++, $str++) {
        $date = $ym . '-' . $day;
        // if ( ( date('D',strtotime($date)) == 'Sat' || date('D',strtotime($date)) == 'Sun')) {
        //     $week .= '<td  style="text-align:center;font-size:12px;padding: 2px 0;">'.$day.' </td>';
        // }else{
        $week .= '<td  style="text-align:center;font-size:12px;padding: 2px 0;">';
        $week .= $day . '</td>';
        // }
        if ((date('D', strtotime($date)) == 'Sat' || date('D', strtotime($date)) == 'Sun')) {
            $data_week .= '<td style="text-align:center;font-size:12px;padding: 2px 0; background:' . $color . ';color:white">';
            $data_week .= 'OFF</td>';
        } else {
            if (strtotime(date('Y-m-d', strtotime($date))) >= strtotime(date('Y-m-d', strtotime($date_start))) && strtotime(date('Y-m-d', strtotime($date))) <= strtotime(date('Y-m-d', strtotime($date_end)))) {
                $start = '';
                $end = '';
                $date_off = '';
                for ($hld = 0; $hld < count($holiday_date); $hld++) {
                    if (strtotime(date('Y-m-d', strtotime($date))) >= strtotime(date('Y-m-d', strtotime($holiday_date[$hld]['start']))) && strtotime(date('Y-m-d', strtotime($date))) <= strtotime(date('Y-m-d', strtotime($holiday_date[$hld]['end'])))) {
                        $date_off = $date;
                    }
                }
                if ($date_off == $date) {
                    $data_week .= '<td style="text-align:center;font-size:12px;padding: 2px 0; background:' . $color . ';color:white">OFF</td>';
                } else {
                    $data_week .= '<td  style="text-align:center;font-size:12px;padding: 2px 0;">$' . $daily . '</td>';
                    $k++;
                }
            } else {
                $data_week .= '<td></td>';
            }
        }
        if ($str % 7 == 0 || $day == $day_count) {
            $weekly_amount = $daily * $k;
            $monthly_target += $weekly_amount;
            $k = 0;
            $weekly_data_amount = 0;
            if ($day == $day_count && $str % 7 != 0) {
                $weekly_data_amount = ($str % 7) * $daily;
                $remain_lst_days = 7 - $str % 7;
                for ($rld = 1; $rld <= $remain_lst_days; $rld++) {
                    $week .= '<td  style="text-align:center;font-size:12px;padding: 2px 0;">' . $rld . '</td>';
                }
            }
            if ($day == $day_count && $str % 7 != 0) {
                $last_empty = 7 - $str % 7;
                for ($rldd = 1; $rldd <= $remain_lst_days; $rldd++) {
                    $next_month_dates = $next_month . '-' . $rldd;
                    if (date('D', strtotime($next_month_dates)) == 'Sat' || date('D', strtotime($next_month_dates)) == 'Sun') {
                        $data_week .= '<td style="text-align:center;font-size:12px;padding: 2px 0; background:' . $color . ';color:white">OFF</td>';
                    } else {
                        $data_week .= '<td></td>';
                    }
                }
                // if(date('D',strtotime($next_month_dates)) == 'Sat' || date('D',strtotime($next_month_dates)) == 'Sun')){
                // }else{
                // }
            }
            $weeks[] = '<tr>' . $week . '<td rowspan=2   style="text-align:center;font-size:12px;">$' . number_format(round($weekly_amount), 2) . '</td></tr>';
            $weeks[] = '<tr>' . $data_week . '</tr>';
            $week = '';
            $data_week = '';
        }
    }
    return array($weeks, round($monthly_target));
}
