<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\Collections;
use App\Models\TargetAllotmentsModel;
// Import Excel Package
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Csv;
use App\Libraries\CSVReader;
use App\Libraries\ImportSheet;
// use PHPMailer\PHPMailer\Exception;
// use PHPMailer\PHPMailer\PHPMailer;
// use PHPMailer\PHPMailer\SMTP;
use App\Traits\EmailTrait;

class TargetAllotments extends BaseController
{
    use EmailTrait;
    public $employe_record;

public function all_record(){
	$result = $this->db->table('date_table')->select('*')->get()->getResult();
    $data['result'] = $result;
    return $data;
}

public function lastID(){
    $result =   $this->db->query('select * from date_table order by id desc limit 1')->getResult();
    if(!$result){
        echo 1;
    }else{
    echo $result[0]->id+1;    
    }
    
}


public function index()
{
   	return view('target_allotments/index');
}

public function file_verification(){
    $result =  $this->db
    ->table('allot_file_verification')
    ->select('*');
    if(isset($_GET['month'])){
        $month = $_GET['month'];
        $result = $result->where("Date", $month);
    }else{
        $month =  date('Y-m');
        $result = $result->where("Date", $month);
    }
    $result = $result->get()->getResult();
    $data['result'] = $result;
    $data['months'] = $month;
    return view('target_allotments/file_verification_department',$data);
}

public function gsb(){
    $result =  $this->db
    ->table('allot_gsb')
    ->select('*');
    if(isset($_GET['month'])){
        $month = $_GET['month'];
        $result = $result->where("Date", $month);
    }else{
        $month =  date('Y-m');
        $result = $result->where("Date", $month);
    }
    $result = $result->get()->getResult();
    $data['result'] = $result;
    $data['months'] = $month;
    return view('target_allotments/gsb_department',$data);
}

public function mlcr_collection(){
    $result =  $this->db
    ->table('allot_mlcr_collection')
    ->select('*');
    if(isset($_GET['month'])){
        $month = $_GET['month'];
        $result = $result->where("Date", $month);
    }else{
        $month =  date('Y-m');
        $result = $result->where("Date", $month);
    }
    $result = $result->get()->getResult();
    $data['result'] = $result;
    $data['months'] = $month;
    return view('target_allotments/mlcr_collection_department',$data);
}

public function mlcr_support(){
    $result =  $this->db
    ->table('allot_mlcr_support')
    ->select('*');
    if(isset($_GET['month'])){
        $month = $_GET['month'];
        $result = $result->where("Date", $month);
    }else{
        $month =  date('Y-m');
        $result = $result->where("Date", $month);
    }
    $result = $result->get()->getResult();
    $data['result'] = $result;
    $data['months'] = $month;
    return view('target_allotments/mlcr_support_department',$data);
}

public function wc_collection(){
    $result =  $this->db->table('allot_wc_collection')->select('*');
    if(isset($_GET['month'])){
        $month = $_GET['month'];
        $result = $result->where("Date", $month);
    }else{
        $month =  date('Y-m');
        $result = $result->where("Date", $month);
    }
    $result = $result->get()->getResult();
    $data['result'] = $result;
    $data['months'] = $month;
    return view('target_allotments/wc_collection_department',$data);
}

public function getEmployeeRecord($post){
        $Departments  = $post['Department'];
        $table        = 'allot_'.$Departments;
        $ID           = $post['ID'];
        $EmpID        = $post['EmpID'];
        $results      = $this->db2->table('employee_history eh')
                             ->select('eh.employee_id,eh.hrm_id,eh.first_name,eh.middle_name,
                                       eh.last_name,eh.email,eh.maiden_name,eh.hire_date,
                                       eh.original_hire_date,divisions.name div_name,eh.pseudo,
                                       eh.shift,`eh`.`super_visor_id`,
                                       ( SELECT
                                             CONCAT(first_name, " ", last_name)
                                           FROM
                                             employee_history
                                             WHERE employee_history.employee_id= eh.`super_visor_id`
    
                                         ) AS manager,
                                         ( SELECT
                                             employee_history.email
                                           FROM
                                             employee_history
                                             WHERE employee_history.employee_id= eh.`super_visor_id`
    
                                         ) AS manager_email 
                                         ')
                                         
                             ->join('user','eh.email = user.email')
                             ->join('divisions','eh.division_id = divisions.id')
                             ->where(['eh.hrm_id'=>$EmpID,'user.status'=>1])
                             ->get()
                             ->getResult();

        $data['status']          = 'fail';
        $data['message']         = 'data not found successfully';
        $data['employee_detail'] = [];
        $data['monthly_target']  = [];
        $data['ID']              = "";
        $data['Departments']     = '';
        $data['EmpID']           = '';
        $data['shift']           = [];
        $status_code             = '302';
        $data['table']           = '';
        $message                 = 'No data found';

        if($results){

            if($results[0]->shift){
                    $shift_holiday = $this->db2->query("
                                                        SELECT
                                                        phs.*,
                                                        (SELECT
                                                        CONCAT(ph.`start_date`,',',ph.`end_date`)
                                                        FROM
                                                        payroll_holiday ph
                                                        WHERE ph.payrl_holi_id = phs.`payrl_holi_id`) AS holiday_date
                                                
                                                        FROM
                                                        `payroll_holiday_shift_wise` phs
                                                        WHERE phs.`shift_id` = {$results[0]->shift};
                                                ")->getResult();   
            }else{
                $shift_holiday = [];
            }

            $data['status']          = 'success';
            $data['message']         = 'data found successfully';
            $data['employee_detail'] = $results;
            $data['table']           = $table;
            $data['ID']              = $ID;
            $data['EmpID']           = $EmpID;
            $data['shift']           = $shift_holiday;
            $data['Departments']     = $Departments;
            $data['monthly_target']  = $this->db->table($table)->where('ID',$ID)->get()->getResult();
            $status_code             = '200';
            $message                 = 'Data found';
        }
        return $data;
}

public function allotment_forms($data,$post){
    if($data['status'] == 'success'){
        $Departments = $post['Department'];
        return view('target_allotments/templates/'.$Departments.'_temp',$data);
    }else{
        $Departments = $post['Department'];
        return view('target_allotments/templates/error_temp',$data);
    }
}

public function showTargetForm(){
    if ($this->request->getMethod() == 'post') {
        $post        = $this->request->getPost();
    }
    $data = $this->getEmployeeRecord($post);
    return $this->allotment_forms($data,$post);
}

public function updateEmailStatus($Departments,$id){
    $table       = 'allot_'.$Departments;
    $this->db->query('update '.$table.' set Email_Sent = (Email_Sent+1) where ID = '.$id)->getResult();
    return  $this->db->query('select Email_Sent from '.$table.'  where ID = '.$id)->getResult();
}

public function approvedAndSend(){
    if ($this->request->getMethod() == 'post') {
        $post        = $this->request->getPost();
        $Departments = $post['Department'];
        $table       = 'allot_'.$Departments;
        $data = $this->getEmployeeRecord($post);

        $rdata['status'] = 'fail';
        $rdata['message'] = 'rdata not found successfully';
        $status_code = '302';
        $message     = 'No data found';
        $rdata['email_status'] = 0;
        if($data['status'] == 'success'){
            $target_allotment_id = $post["ID"];
            $message = 'You have target allotment form please check your target form <a href="'.base_url("employee_target_form?empID={$post['EmpID']}&id={$target_allotment_id}&department={$Departments}").'">click here</a>';
            // $response =  1;
            $response =  $this->sendMail($data['employee_detail'][0]->email,$message,"Monthly Target Allotment");
            if($response >=1){
                $rdata['status'] = 'success';
                $rdata['message'] = 'email successfully Sent';
                $status_code = '200';
                $message     = 'Data Transfered Successfully';
                $Email_Sent = $this->updateEmailStatus($Departments,$target_allotment_id);
                $rdata['Email_Sent'] =
                 ($Email_Sent[0]->Email_Sent > 1 ? 'Sent ('.$Email_Sent[0]->Email_Sent.')' : 'Sent');
            }
        }
        return $this->response->setStatusCode($status_code,$message)->setJSON($rdata);
    }

}

    public function importSheet(){
    	$post    = $this->request->getPost();
    	$session = session();
    	if ($this->request->getMethod() == "post") {
			$department = $post['department'];
            $table = 'allot_'.$department;
			$file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			$arr_file = explode('.', $_FILES['upload_file']['name']);
			 $extension = end($arr_file);
			if($extension !='csv'){
                $session->setFlashdata('error', 'Only Csv File You Can Import');
                return redirect()->to(base_url('target_allotments/'.$department));
            }

            if('csv' == $extension){
				$reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
			} else {
				$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
			}   
            
			$spreadsheet = $reader->load($_FILES['upload_file']['tmp_name']);
     
			$sheetData   = $spreadsheet->getActiveSheet()->toArray();
 
			if($sheetData){
			
                $total_array        = [];
            
                $table_fields       = tables_fields_count($table,['Date','Email_Sent','Target_Status','ID','Rejected_Date','Accepted_Date'],'count');
            
                $table_fields_data  = tables_fields_count($table,['Date','Email_Sent','Target_Status','ID','Rejected_Date','Accepted_Date']);
            
                $sheet_columns      = sheet_fields_count($sheetData[0]);
            
                if($sheet_columns > $table_fields || $sheet_columns < $table_fields){
            
                    $session->setFlashdata('error', 'Something Went Wrong Sheet Not Imported Successfully Check The Fields Carefully');
            
                    return redirect()->to(base_url('target_allotments/'.$department));
            
                }
            
            }

            $this->db->transStart();
            foreach($sheetData as $key=>$value){
				if($key>0){
                    foreach($table_fields_data as $t_key=>$t_value){
                        $mult_array[$t_value] = $value[$t_key];
                    }
                    $mult_array['Date'] = $post['date'];
                    $this->db->table($table)->insert($mult_array);		
				}
	    	}
            $this->db->transComplete();
            if($this->db->transStatus() === true){
                $session->setFlashdata('success', 'Data Imported Successfully');
                return redirect()->to(base_url('target_allotments/'.$department.'?month='.$post['date']));
            }else{
                $session->setFlashdata('error', 'Something went wrong');
                return redirect()->to(base_url('target_allotments/'.$department.'?month='.$post['date']));
            }
	}else{
        $session->setFlashdata('error', 'Something went wrong');
        return redirect()->to(base_url('target_allotments/'.$department));
    }
}
    
    public function employee_target_form(){
        $success = 1;

            $post['EmpID'] = "";
            $post['ID']= "";
            $post['Department']= "";
            if($_GET['empID']){
                $post['EmpID'] = $_GET['empID'];
            }
            if($_GET['id']){
                $post['ID'] = $_GET['id'];
            }
            if($_GET['department']){
                $post['Department'] = $_GET['department'];
            }

        $data = $this->getEmployeeRecord($post);
        $data['is_employee'] =  1; 
        return $this->allotment_forms($data,$post);
    }
    // public function convertPDF(){
    //     $this->employee_target_form();
    // }

    // public function update_target_status($post){
    //     $table       = 'allot_'.$Departments;
    //     $this->db->query('update '.$table.' set Email_Sent = (Email_Sent+1) where ID = '.$id)->getResult();
    //     return  $this->db->query('select Email_Sent from '.$table.'  where ID = '.$id)->getResult();
    // }

    public function target_assigned_employee(){
       
        $post    = $this->request->getPost();
      
        if ($this->request->getMethod() == "post") {
        
            $department = $post['Department'];
         
            $table = 'allot_'.$department;
         
            $id = $post['ID'];
            $date = date('Y-m-d');
            if(!empty($post['ID']) &&
               !empty($post['Department']) &&
               !empty($post['EmpID']) && 
               !empty($post['status'])
               ){
                    $data = $this->getEmployeeRecord($post);
                    // print_r($data);die;
                    if($post['status'] == 2){
                        // ,'Rejected_Date','Accepted_Date'
                        $this->db->query('update '.$table.' set Target_Status = 2,Rejected_Date='.date('Y-m-d').' where ID = '.$id)->getResult();

                        $message = $post['EmpID'] . '('.$data['Departments'].') Rejected the ' . $data['monthly_target'][0]->Date . ' Taraget <br>';
                        $message .= 'Reason: '.$post['reason'];

                        $this->sendMail($data['employee_detail'][0]->manager_email,$message,"Monthly Target Allotment Rejected");

                        $rdata['message'] = 'Target is rejected by employee, email sent to the supervisor';

                        $rdata['target']  = 'Rejected';

                        $rdata['status']  = 'fail';

                        return $this->response->setJSON($rdata); 

                    }
                    $upload_document['document_type'] = 56;
                  
                    $upload_document['employee_id'] = $post['employee_id'];
                  
                    $upload_document['documents']   = $post['EmpID'].'-'.date('Ymdhis').'.pdf';
                    
                    $upload_document['created_date'] = date('Y-m-d');
  

                   
                    $dompdf = new \Dompdf\Dompdf(); 
                   
                    $data['pdf_extra_style']  = 1;
                    
                    $dompdf->loadHtml($this->allotment_forms($data,$post));
                  
                    $dompdf->setPaper('legal', 'portrait');
                  
                    $dompdf->render();
                   
                    $pdfroot    = FCPATH.'/target_folders/';
                    
                    $pdf_string = $dompdf->output();
        
                    $moved = file_put_contents($pdfroot.$upload_document['documents'], $dompdf->output()); 
                   
                    if($moved){
                            $this->db->query('update '.$table.' set Target_Status = 1, Rejected_Date='.$date.' where ID = '.$id)->getResult();
                           
                            $this->db2->table('upload_documents')->insert($upload_document);
                           
                            $rdata['message'] = 'Accepted document moved successfully';
                        
                            $rdata['target']  = 'Accepted';
                           
                            $rdata['status']  = 'success';

                    }else{
                       
                        $rdata['message'] = 'Something went wrong';
                        
                        $rdata['target']  = 'Error';
                        $rdata['status']  = 'fail';

                    }
            }else{

                $rdata['message'] = 'Something went wrong';
                $rdata['target']  = 'Error';
                $rdata['status']  = 'fail';

            }

            return $this->response->setJSON($rdata); 
          
        }
    }

    public function custom_put_contents($source_url='',$local_path=''){

        $time_limit = ini_get('max_execution_time');
        $memory_limit = ini_get('memory_limit');
    
        set_time_limit(0);
        ini_set('memory_limit', '-1');      
    
        $remote_contents=file_get_contents($source_url);
        $response=file_put_contents($local_path, $remote_contents);
    
        set_time_limit($time_limit);
        ini_set('memory_limit', $memory_limit); 
    
        return $response;
    }


    public function checkEmailExists(){
        $post    = $this->request->getPost();
    
        if ($this->request->getMethod() == "post") {
            $rdata['status']  = 'fail';
            $rdata['message'] = 'data not found successfully';
            $status_code      = '302';
            $message          = 'No data found';
            $rdata['data']    = [];
            $rdata['emailCount'] = 0;

            if(!isset($post['ids'])){
                $rdata['status'] = 'post_error';
                return $this->response->setJSON($rdata);
            }
            
            $ID = explode(', ',$post['ids']);
            $department = $post['department'];
            $table = 'allot_'.$department;
            $table_data = $this->db->table($table)
                                   ->select('EMP_ID')
                                   ->where('Date',$post['date'])
                                   ->whereIn('Target_Status',['0','2'])->whereIn('ID',$ID)->get()->getResult();
            $empIDs = [];
            foreach($table_data as $key=>$value){
                $empIDs[] = $value->EMP_ID;
            }
  
           if($empIDs){
                $rdata['status']  = 'success';
                $rdata['message'] = 'data found successfully';
                $status_code      = '200';
                $message          = 'data found';
                foreach($empIDs as $r_key=>$r_value){
                    $results = $this->db2->table('employee_history eh')
                                         ->select('eh.hrm_id,eh.email')
                                         ->join('user','eh.email=user.email')
                                         ->join('divisions','eh.division_id=divisions.id')
                                         ->where('hrm_id',$r_value)
                                         ->where(['user.status'=>1])
                                         ->get()->getResultArray();
                    $empIDS_found= [];
                    $i = 0;
                    if($results){
                        $empIDS_found['empID'] = $results[0]['hrm_id'];
                        $empIDS_found['empEmail'] = $results[0]['email'];
                        $empIDS_found['department'] = $department;
                        $empIDS_found['allotment_id'] = $ID[$r_key];
                        $empIDS_found['Date'] = $ID[$r_key];
                        $empIDS_found['message'] = 'Found';
                        $i++;
                    }else{
                        $empIDS_found['empID']  = $r_value;
                        $empIDS_found['empEmail'] = '';
                        $empIDS_found['department'] = $department;
                        $empIDS_found['allotment_id'] = $ID[$r_key];
                        $empIDS_found['message'] = 'Email Not Found';
                    }
                    $rdata['data'][]    = $empIDS_found;   
                }
                $rdata['emailCount'] = count($empIDs);
                
           }else{
                $rdata['status']  = 'fail';
                $rdata['message'] = 'data not found successfully';
                $status_code      = '302';
                $message          = 'data found';
                $rdata['emailCount'] = 0;
                $rdata['data']      = [];
           }
           return $this->response->setJSON($rdata);  
        }
    }
}
